local super = require "Object"

ParsedLogic = super:new()

function ParsedLogic:new(string)
    self = super.new(self)
    
    self._string = string
    self._tokens = nil
    self._isBuilt = false
    self._function = nil
    self._dependencies = nil
    self._errorString = nil
    self._errorToken = nil
    
    return self
end

function ParsedLogic:archive()
    return nil, self._string
end

function ParsedLogic:getInputString()
    return self._string
end

function ParsedLogic:tokenize()
    self._tokens = LogicParser:tokenize(self._string)
end

function ParsedLogic:build()
    if not self._tokens then
        self:tokenize()
    end
    local errorFunction = function(string, token)
        self._errorString = string
        self._errorToken = token
    end
    self._function, self._dependencies = LogicParser:build(self._tokens, errorFunction)
    self._isBuilt = true
end

function ParsedLogic:getFunction()
    if not self._isBuilt then
        self:build()
    end
    return self._function
end

function ParsedLogic:getDependencies()
    if not self._isBuilt then
        self:build()
    end
    return self._dependencies
end

function ParsedLogic:getError()
    if not self._isBuilt then
        self:build()
    end
    return self._errorString, self._errorToken
end

function ParsedLogic:tokenCount()
    if not self._tokens then
        self:tokenize()
    end
    return #self._tokens
end

function ParsedLogic:tokenIter()
    if not self._tokens then
        self:tokenize()
    end
    local index = 1
    return function()
        local result = self._tokens[index]
        index = index + 1
        return result
    end
end

return ParsedLogic
